/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.sysutils;

import filenet.pe.ceutils.ConnectionPoint;
import filenet.vw.api.VWException;
import filenet.vw.base.IVWMemory;
import filenet.vw.base.PathUtils;
import filenet.vw.base.logging.Level;
import filenet.vw.base.logging.Logger;
import filenet.vw.server.IVWRouter;
import filenet.vw.sysutils.testGetRouters;
import filenet.vw.toolkit.utils.VWCommandLineArgs;
import java.io.BufferedReader;
import java.io.FileReader;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.rmi.Naming;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.util.Hashtable;
import java.util.Vector;

public class Registry {
    protected static String m_className = "Registry";
    protected static Logger logger = Logger.getLogger("filenet.vw.sysutils");
    private static Method ConnectionPoints_GetConnectionPoints_method = null;
    private static Method ConnectionPoints_GetConnectionPointNames_method = null;
    private static final String ROUTER_PREFIX = "FileNET.VW.VWRouter.";
    private static final String PECP_FILE_NAME = "P8PECP.properties";

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String[] getRouters(String hostName, int portNumber, boolean ping) throws VWException {
        String[] stringArray;
        String method = "getRouters";
        PathUtils p = new PathUtils();
        BufferedReader in = null;
        try {
            try {
                String s;
                String loc = p.getResourceLocation(PECP_FILE_NAME);
                Vector<String> v = new Vector<String>();
                in = new BufferedReader(new FileReader(loc));
                while ((s = in.readLine()) != null) {
                    v.add(s);
                }
                stringArray = v.toArray(new String[0]);
                Object var12_12 = null;
                if (in == null) return stringArray;
            }
            catch (Exception e) {
                throw new VWException(e);
            }
        }
        catch (Throwable throwable) {
            Object var12_13 = null;
            if (in == null) throw throwable;
            try {
                in.close();
                throw throwable;
            }
            catch (Exception e2) {
                logger.log(Level.FINE, m_className, method, "", e2);
                throw throwable;
            }
        }
        try {}
        catch (Exception e2) {
            logger.log(Level.FINE, m_className, method, "", e2);
            return stringArray;
        }
        in.close();
        return stringArray;
    }

    public String[] getRoutersDirectlyFromCE(String hostName, int portNumber, boolean ping) throws VWException {
        String m_method = "getRoutersDirectlyFromCE:" + hostName;
        if (ConnectionPoints_GetConnectionPoints_method == null) {
            if (logger.isFinest()) {
                logger.finest(m_className, m_method, "No Connection Points!!!");
            }
            throw new VWException("vw.util.MissingCEJARs", "Missing classes for retrieving connection points.  Make sure that CE jar files are included in the classpath.");
        }
        try {
            ConnectionPoint[] cps = (ConnectionPoint[])ConnectionPoints_GetConnectionPoints_method.invoke(null, null, null, null);
            if (cps == null) {
                return null;
            }
            int nCps = cps == null ? 0 : cps.length;
            String[] res = new String[nCps];
            for (int i = 0; i < nCps; ++i) {
                res[i] = new StringBuffer().append(cps[i].Name).append(",").append(cps[i].BrokerPort).append(",").append(cps[i].DNSName).append(",").append(cps[i].IsolatedRegionNumber).toString();
            }
            if (logger.isFinest()) {
                logger.finest(m_className, m_method, Logger.asString(res));
            }
            return res;
        }
        catch (Throwable e) {
            throw new VWException(e);
        }
    }

    /*
     * Loose catch block
     */
    public String[] getRouterURLs(String hostName, int portNumber, boolean ping) throws VWException {
        String[] stringArray;
        BufferedReader in;
        String m_method;
        String method;
        block12: {
            String s;
            method = "getRouterURLs";
            m_method = "getRouterURLs:" + hostName;
            logger.entering(m_className, m_method);
            PathUtils p = new PathUtils();
            in = null;
            String loc = p.getResourceLocation(PECP_FILE_NAME);
            if (logger.isFinest()) {
                logger.finest(m_className, m_method, loc);
            }
            Vector<String> v = new Vector<String>();
            in = new BufferedReader(new FileReader(loc));
            while ((s = in.readLine()) != null) {
                if (logger.isFinest()) {
                    logger.finest(m_className, m_method, s);
                }
                String[] tokens = s.split(",");
                String routerURL = "rmi://" + hostName + ":" + portNumber + "/" + tokens[0];
                if (logger.isFinest()) {
                    logger.finest(m_className, "getRouterURLs", routerURL);
                }
                v.add(routerURL);
            }
            stringArray = v.toArray(new String[0]);
            Object var14_14 = null;
            if (in == null) break block12;
            try {
                in.close();
            }
            catch (Exception e2) {
                logger.log(Level.FINE, m_className, method, "", e2);
            }
        }
        logger.exiting(m_className, m_method);
        return stringArray;
        catch (Exception e) {
            try {
                throw new VWException(e);
            }
            catch (Throwable throwable) {
                Object var14_15 = null;
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (Exception e2) {
                        logger.log(Level.FINE, m_className, method, "", e2);
                    }
                }
                logger.exiting(m_className, m_method);
                throw throwable;
            }
        }
    }

    public String[] getRouterURLsOld(String hostName, int portNumber, boolean ping) throws VWException {
        Object[] routerURLs = null;
        Vector<String> routerURLVector = new Vector<String>();
        String routerName = null;
        IVWRouter router = null;
        try {
            String[] urls = Naming.list("rmi://" + hostName + ":" + Integer.toString(portNumber));
            if (urls == null) {
                return routerURLs;
            }
            Hashtable<String, String> routerNameHash = new Hashtable<String, String>();
            for (int i = 0; i < urls.length; ++i) {
                routerName = Registry.parseRouterName(urls[i]);
                if (routerName == null || routerNameHash.containsKey(routerName)) continue;
                try {
                    routerNameHash.put(routerName, "");
                    router = Registry.lookupRouter(routerName, hostName, portNumber);
                    if (ping) {
                        router.getIsolatedRegion();
                    }
                    routerURLVector.addElement("rmi://" + hostName + ":" + Integer.toString(portNumber) + "/" + routerName);
                    continue;
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
            int routerCount = routerURLVector.size();
            if (routerCount > 0) {
                routerURLs = new String[routerCount];
                routerURLVector.copyInto(routerURLs);
            }
        }
        catch (RemoteException e) {
        }
        catch (MalformedURLException e) {
            throw new VWException("vw.util.VWRouterLookupError", "Error getting active routers: {0}", e.getLocalizedMessage());
        }
        return routerURLs;
    }

    public String[] getRoutersOld(String hostName, int portNumber, boolean ping) throws VWException {
        Object[] routers = null;
        try {
            String[] urls = Naming.list("rmi://" + hostName + ":" + Integer.toString(portNumber));
            if (urls == null) {
                return null;
            }
            Hashtable<String, String> routerNameHash = new Hashtable<String, String>();
            Vector<String> routerVector = new Vector<String>();
            for (int i = 0; i < urls.length; ++i) {
                String routerName = Registry.parseRouterName(urls[i]);
                if (routerName == null || routerNameHash.containsKey(routerName)) continue;
                try {
                    routerNameHash.put(routerName, "");
                    IVWRouter router = Registry.lookupRouter(routerName, hostName, portNumber);
                    if (ping) {
                        router.getIsolatedRegion();
                    }
                    String routerInfo = routerName + ", " + router.getRouterPort() + ", " + router.getServiceURL() + ", " + router.getIsolatedRegion();
                    routerVector.addElement(routerInfo);
                    continue;
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
            if (routerVector != null && routerVector.size() > 0) {
                routers = new String[routerVector.size()];
                routerVector.copyInto(routers);
            }
        }
        catch (RemoteException ex) {
        }
        catch (MalformedURLException ex) {
            throw new VWException("vw.util.VWRouterLookupError", "Error getting active routers: {0}", ex.getLocalizedMessage());
        }
        return routers;
    }

    private static String parseRouterName(String url) {
        int beginIndex;
        int endIndex;
        String routerName = null;
        int prefixStart = url.indexOf(ROUTER_PREFIX);
        if (prefixStart != -1 && (endIndex = url.indexOf(".", beginIndex = prefixStart + ROUTER_PREFIX.length())) == -1) {
            endIndex = url.length();
            routerName = url.substring(beginIndex, endIndex);
        }
        return routerName;
    }

    private static IVWRouter lookupRouter(String routerName, String hostName, int rmiPort) throws Exception {
        String url = "rmi://" + hostName + ":" + Integer.toString(rmiPort) + "/" + ROUTER_PREFIX + routerName;
        return (IVWRouter)Naming.lookup(url);
    }

    private static void usage() {
        System.out.println("View and/or remove entries from the RMI registry.");
        System.out.println("");
        System.out.println("Usage:  Registry <options> [/p port] ");
        System.out.println("where options are:");
        System.out.println("     /v [remote system] - view contents of rmiregistry");
        System.out.println("     /r <object name>   - remove <object name> from rmiregistry");
        System.out.println("     /R                 - remove all objects from rmiregistry");
        System.out.println("     /V                 - print the version of the running objects ..");
        System.out.println("     /getRouters40      - print the P8PECP.properties contents..");
        System.exit(1);
    }

    public static void main(String[] args) {
        String HELP = "?";
        String VIEW = "v";
        String REMOVE = "r";
        String REMOVE_ALL = "R";
        String PORT = "p";
        String VERSION2 = "V";
        String GET_ROUTERS = "getRouters";
        try {
            VWCommandLineArgs c = new VWCommandLineArgs(args, false);
            java.rmi.registry.Registry reg = null;
            int port = c.getIntParameter("p", 32771);
            boolean wantVersion = c.isPresent("V");
            if (c.isPresent("?") || args.length < 1) {
                Registry.usage();
            } else if (c.isPresent("v")) {
                String[] list;
                String hostName = c.getParameter("v");
                if (hostName == null || hostName.length() == 0) {
                    hostName = "localhost";
                }
                System.out.println("Host " + hostName);
                if (hostName != null) {
                    reg = LocateRegistry.getRegistry(hostName, port);
                }
                int listSize = (list = reg.list()) == null ? 0 : list.length;
                for (int i = 0; i < listSize; ++i) {
                    System.out.println(list[i]);
                }
                if (wantVersion && listSize > 0) {
                    String version = null;
                    StringBuffer versionBuf = new StringBuffer(512);
                    for (int i = 0; i < listSize; ++i) {
                        try {
                            String url = "rmi://" + hostName + ":" + Integer.toString(port) + "/" + list[i];
                            IVWMemory obj = (IVWMemory)Naming.lookup(url);
                            if (url.indexOf("WorkflowSimulator") != -1) {
                                System.out.println("Trying simulator.util.VWBuildStamp");
                                version = obj.getVersion("simulator.util.VWBuildStamp");
                                if (version != null) {
                                    versionBuf.append("\nChecking version of ").append(url).append("\n");
                                    versionBuf.append(version);
                                }
                            }
                            if ((version = obj.getVersion("filenet.vw.toolkit.utils.VWBuildStamp")) == null) continue;
                            versionBuf.append("\nChecking version of ").append(url).append("\n");
                            versionBuf.append(version);
                            break;
                        }
                        catch (Throwable e) {
                            // empty catch block
                        }
                    }
                    if (version != null) {
                        System.out.println(versionBuf.toString());
                    } else {
                        System.out.println("Version information not available.");
                    }
                }
            } else if (c.isPresent("r")) {
                reg = LocateRegistry.getRegistry(port);
                String objectName = c.getParameter("r");
                if (objectName != null) {
                    System.out.println("Removing..." + objectName);
                    reg.unbind(objectName);
                } else {
                    Registry.usage();
                }
            } else if (c.isPresent("R")) {
                reg = LocateRegistry.getRegistry(port);
                String[] list = reg.list();
                for (int i = 0; i < list.length; ++i) {
                    System.out.println("Removing..." + list[i]);
                    reg.unbind(list[i]);
                }
            } else if (c.isPresent("getRouters")) {
                testGetRouters t = new testGetRouters(c.getParameter("getRouters"));
                t.printInfo();
            } else if (c.isPresent("getRouters40")) {
                String[] routers = new Registry().getRouters("localhost", 32771, false);
                int nRouters = routers == null ? 0 : routers.length;
                for (int i = 0; i < nRouters; ++i) {
                    System.out.println(i + ":" + routers[i]);
                }
            } else {
                Registry.usage();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.exit(1);
    }

    static {
        try {
            Class<?> connectionPointsClass = Class.forName("filenet.pe.ceutils.ConnectionPoints");
            ConnectionPoints_GetConnectionPoints_method = connectionPointsClass.getMethod("GetConnectionPoints", String.class, String.class, String.class);
            ConnectionPoints_GetConnectionPointNames_method = connectionPointsClass.getMethod("GetConnectionPointNames", String.class, String.class, String.class);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

